/*
This code replicates Figure #9: Inflation (2007-2021)

*/

clear
set more off
cls 

cap cd "Replication_pkg/Figure 9"


use "Data_fig9_final.dta"

graph set window fontface "Times New Roman"
***************
* Combined Inflations 
* 1y  Inflation Expectations
* All
twoway lfit ConsensusandFocusandWEO1YA IAPOC if(ConsensusandFocusandWEO1YA <= 25 & ConsensusandFocusandWEO1YA >= 0),  lc(black) ///
	|| (scatter ConsensusandFocusandWEO1YA IAPOC if(EM==0 & ConsensusandFocusandWEO1YA <= 25 & ConsensusandFocusandWEO1YA >= 0), mc(blue) m(Oh)) ///
	|| (scatter ConsensusandFocusandWEO1YA IAPOC if(EM == 1  & ConsensusandFocusandWEO1YA <= 25 & ConsensusandFocusandWEO1YA >= 0), mc(red) m(Oh)), ///
	ytitle("") ylab(, nogrid)  yla(0(4)24,  labsize(small)) ///
	xtitle("Policy Credibility Index")  xlab(, nogrid)  xla(0(.2)1,  labsize(small)) ///
	ti("1-Year Ahead Inflation Expectations")   legend(pos(6) order(2 "AE"  3 "EM") cols(2)) ///
	name(ColorAllRegress_1yAheadInflation,replace)


* 5y  Inflation Expectations
* All
twoway lfit ConsensusandFocusandWEO5YA IAPOC if(ConsensusandFocusandWEO5YA <= 12 & ConsensusandFocusandWEO5YA >= 0),  lc(black) ///
	|| (scatter ConsensusandFocusandWEO5YA IAPOC if(EM == 0 & ConsensusandFocusandWEO5YA <= 12 & ConsensusandFocusandWEO5YA >= 0), mc(blue) m(Oh)) ///
	|| (scatter ConsensusandFocusandWEO5YA IAPOC if(EM == 1  & ConsensusandFocusandWEO5YA <= 12 & ConsensusandFocusandWEO5YA >= 0), mc(red) m(Oh)), ///
	ytitle("") ylab(, nogrid)  yla(0(2)12,  labsize(small)) ///
	xtitle("Policy Credibility Index") xlab(, nogrid)  xla(0(.2)1,  labsize(small)) ///
	ti("5-Year Ahead Inflation Expectations")   legend(pos(6) order(2 "AE"  3 "EMDE") cols(2)) ///
	name( ColorAllRegress_5yAheadInflation,replace)

*Year-on-year  Inflation
* All
twoway lfit Inflation2020Q12023Q1 IAPOC if(Inflation2020Q12023Q1 <= 25 & Inflation2020Q12023Q1 >=0),  lc(black) ///
	|| (scatter Inflation2020Q12023Q1 IAPOC if(EM == 0 & Inflation2020Q12023Q1 <= 25 & Inflation2020Q12023Q1 >=0), mc(blue) m(Oh)) ///
	|| (scatter Inflation2020Q12023Q1 IAPOC if(EM == 1  & Inflation2020Q12023Q1 <= 25 & Inflation2020Q12023Q1 >=0), mc(red) m(Oh)), ///
	ytitle("") ylab(, nogrid)  yla(0(4)24,  labsize(small)) ///
	xtitle("Policy Credibility Index") xlab(, nogrid)  xla(0(.2)1,  labsize(small)) ///
	ti("Year-on-year Inflation") legend(pos(6) order(2 "AE"  3 "EMDE") cols(2)) ///
	name( ColorAllRegress_YoYInflation,replace)


* 5y Moving Average Inflation
* All
twoway lfit InflationMA5Years IAPOC if(InflationMA5Years <= 25 & InflationMA5Years >=0),  lc(black) ///
	|| (scatter InflationMA5Years IAPOC if(EM == 0 & InflationMA5Years <= 25 & InflationMA5Years >=0), mc(blue) m(Oh)) ///
	|| (scatter InflationMA5Years IAPOC if(EM == 1  & InflationMA5Years <= 25 & InflationMA5Years >=0), mc(red) m(Oh)), ///
	ytitle("") ylab(, nogrid)  yla(0(4)24,  labsize(small)) ///
	xtitle("Policy Credibility Index") xlab(, nogrid)  xla(0(.2)1,  labsize(small)) ///
	ti("5-Year Moving Average Inflation")   legend(pos(6) order(2 "AE"  3 "EMDE") cols(2)) ///
	name( ColorAllRegress_5yMAInflation,replace)

grc1leg ColorAllRegress_1yAheadInflation ColorAllRegress_5yAheadInflation ColorAllRegress_YoYInflation ColorAllRegress_5yMAInflation, rows(2)
graph export "fig9.pdf", replace









